#ifndef __FVOS_CONFIG_H__
#define __FVOS_CONFIG_H__


/*
   *  Object %name    : FVOS_Config.h
   *  State           :  %state%
   *  Creation date   :  Wed Nov 17 17:39:24 2004
   *  Last modified   :  %modify_time%
   */
  /** @file
   *  \brief FVOS h file (API and structures )
   *
   *  \version 
   *  \author yevgenys
   *  \remarks Copyright (C) 2004 by Discretix Technologies Ltd.
   *           All Rights reserved
   */




/*------------------------------
    DEFINES
--------------------------------*/

/* Marks free flow id (meaning it is free no flow in occupying it) */
#define FVOS_FREE_FLOW_ID                       0x4

/* memory for the system data pool */
#define FVOS_SYSTEM_DATA_MEMORY_SIZE_IN_BYTES   100

/* memory for the FLOW DMA tables  - 4K */
#define FVOS_FLOW_DMA_MEMORY_SIZE_IN_BYTES      (1024 * 4)

/* the size of memory for the symmetric synchronic DMA tables */
#define FVOS_SYM_DMA_MEMORY_SIZE_IN_BYTES       100

/* size of allocation memory area in bytes */
#define FVOS_ALLOC_MEMORY_SIZE_IN_BYTES         (12 * 1024)

/* size of static memory area in bytes */
#define FVOS_STATIC_MEMORY_SIZE_IN_BYTES        (4 * 1024)

/* size of message memory area in bytes */
#define FVOS_MESSAGE_MEMORY_SIZE_IN_BYTES       (10 * 1024)

/* token that always precedes valid time value */
#define FVOS_TIME_VAL_TOKEN                     0x12345678

/* maximum number of entries in fow table */
#define FVOS_FLOW_MAX_NUM_ENTRIES_IN_TABLE      8

/* default flow id */
#define FVOS_DEFAULT_FLOW_ID                    0xFFFFFFFF

/* number of flows */
#define FVOS_NUM_FLOWS                          4

/* offset of the num entries in the block length entry of the LLI */
#define FVOS_NUM_ENTRIES_OFFSET_IN_BITS         24

/* offset of the interrupt flag in the block length entry of the LLI */
#define FVOS_INT_FLAG_OFFSET_IN_BITS            31

/* mask for extracting data size from LLI */
#define FVOS_TABLE_DATA_SIZE_MASK               0xFFFFFF

/* mask for entries after being shifted left */
#define FVOS_NUM_ENTRIES_MASK                   0x7F

/* maximum message of the add tables in words */
#define FVOS_MAX_ADD_MESSAGE_LENGTH_IN_WORDS    11

/* maximum message of the add tables in bytes */
#define FVOS_MAX_ADD_MESSAGE_LENGTH_IN_BYTES    (FVOS_MAX_ADD_MESSAGE_LENGTH_IN_WORDS << 2)  
              

#define FVOS_WriteRegister(addr,val) \
{ \
  ( (*((volatile DxUint32_t*)(addr))) = (DxUint32_t)(val) ); \
}
#define FVOS_ReadRegister(addr,val) \
{ \
  ( (val) = (*((volatile DxUint32_t*)(addr))) ); \
}

#define FVOS_WAIT_SRAM_WRITE_COMPLETE() \
do \
{ \
  DxUint32_t  WAIT_WRITE_regVal; \
  do \
  { \
    FVOS_ReadRegister( GEN_HW_SRAM_DATA_READY_REG_ADDR, (WAIT_WRITE_regVal) ); \
  }while(!(WAIT_WRITE_regVal & 0x1)); \
}while(0)


/*-------------------------------
  typedefs
---------------------------------*/


typedef struct _FVOS_LliEntry_t
{
  /* physical address */
  DxUint32_t  physicalAddress;
  
  /* block length */
  DxUint32_t  blockLength;
  
}FVOS_LliEntry_t;



typedef struct _FVOS_FlowData_t
{
  DxUint32_t        flowId;
  
  /* additional input tables exists */
  DxUint32_t        inputTablesFlag;
  
  /* additional output tables exists */
  DxUint32_t        outputTablesFlag;
  
  /*  address of the first input file */
  FVOS_LliEntry_t   firstInputTable;
  
  /* address of the first output table */
  FVOS_LliEntry_t   firstOutputTable;
  
  /* first input table data (num_entries+size) */
  FVOS_LliEntry_t   lastInputTable;
  
  /* first output table data (num_entries+size) */
  FVOS_LliEntry_t   lastOutputTable;
  
  /* first list of table */
  FVOS_LliEntry_t   inputTablesInProcess;
  
  /* output table in process (in sep) */
  FVOS_LliEntry_t   outputTablesInProcess;
  
  /* size of messages in bytes */
  DxUint32_t        messageSizeInBytes;
  
  /* message */
  DxUint8_t         message[FVOS_MAX_ADD_MESSAGE_LENGTH_IN_BYTES];
  
}FVOS_FlowContext_t;


#endif
